package com.hero.objects.powers;

import org.jdom.Element;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.objects.characteristics.Characteristic;
import com.hero.objects.modifiers.Modifier;
import com.hero.util.Constants;
import com.hero.util.Rounder;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class KillingAttackHTH extends Power {

	private static String xmlID = "HKA";

	public KillingAttackHTH(Element root) {
		super(root, KillingAttackHTH.xmlID);
	}

	@Override
	public String getColumn2Output() {
		String ret = getAlias() + " " + getDamageDisplay();
		if (getName().trim().length() > 0) {
			ret = "<i>" + getName() + ":</i>  " + ret;
		}
		if ((getInput() != null) && (getInput().trim().length() > 0)
				&& !HeroDesigner.getInstance().getPrefs().useWG()) {
			ret += " (vs. " + getInput() + ")";
		}
		if (getSelectedOption() != null) {
			ret += " (";
			ret += getSelectedOption().getAlias();

			String adderString = getAdderString();
			if (adderString.trim().length() > 0) {
				ret += "; " + adderString;
			}
			ret += ")";
		} else {
			String adderString = getAdderString();
			if (adderString.trim().length() > 0) {
				ret += " (" + adderString + ")";
			}
		}
		ret += getModifierString();
		if ((getEndUsage() > 0)
				&& (GenericObject.findObjectByID(HeroDesigner.getActiveHero()
						.getPowers(), "ENDURANCERESERVE") != null)
				&& (GenericObject.findObjectByID(getAllAssignedModifiers(),
						"ENDRESERVEOREND") == null)
				&& !HeroDesigner.getInstance().getPrefs().useWG()) {
			if (getUseENDReserve()) {
				ret += " (uses END Reserve)";
			} else {
				ret += " (uses Personal END)";
			}
		}
		return ret;
	}

	@Override
	public String getDamageDisplay() {
		String ret = "";
		int dc = getLevels() * 3;
		int strDC = dc;
		int strDC2 = dc;
		int minus = 0;
		int stunMult = 2;

		int additional = 0;

		if (GenericObject.findObjectByID(getAllAssignedModifiers(),
				"INCREASEDSTUNMULTIPLIER") != null) {
			Modifier mod = (Modifier) GenericObject.findObjectByID(
					getAllAssignedModifiers(), "INCREASEDSTUNMULTIPLIER");
			stunMult += mod.getLevels();
		}
		if (GenericObject.findObjectByID(getAllAssignedModifiers(),
				"DECREASEDSTUNMULTIPLIER") != null) {
			Modifier mod = (Modifier) GenericObject.findObjectByID(
					getAllAssignedModifiers(), "DECREASEDSTUNMULTIPLIER");
			stunMult -= mod.getLevels();
		}
		for (Adder ad : getAssignedAdders()) {
			if (ad.getXMLID().equals("PLUSONEPIP")) {
				ad.setDisplayInString(false);
				dc += 1;
			}
			if (ad.getXMLID().equals("PLUSONEHALFDIE")) {
				ad.setDisplayInString(false);
				dc += 2;
				additional -= 1;
			}
			if (ad.getXMLID().equals("MINUSONEPIP")) {
				ad.setDisplayInString(false);
				dc += 3;
				minus = 1;
				additional -= 2;
			}
		}
		strDC = dc - minus;
		int stdSTR = dc + additional;
		strDC2 = dc - minus;
		int stdSTR2 = dc + additional;
		int minStrength = 0;
		boolean noSTR = GenericObject.findObjectByID(getAllAssignedModifiers(),
				"NOSTRBONUS") != null;
		if (GenericObject.findObjectByID(getAllAssignedModifiers(),
				"STRMINIMUM") != null) {
			Modifier mod = (Modifier) GenericObject.findObjectByID(
					getAllAssignedModifiers(), "STRMINIMUM");
			if (GenericObject.findObjectByID(mod.getAssignedAdders(),
					"CANNOTADD") != null) {
				noSTR = true;
			} else if (mod.getSelectedOption() != null) {
				try {
					minStrength = Integer.parseInt(mod.getSelectedOption()
							.getAlias());
				} catch (Exception exp) {
					noSTR = true;
				}
			} else {
				noSTR = true;
			}
		}
		if (!noSTR) {
			double adv = 1;
			for (Modifier mod : getAllAssignedModifiers()) {
				if ((mod.getTotalValue() > 0)
						&& !mod.getXMLID().equals("REDUCEDEND")) {
					adv += mod.getTotalValue();
				}
			}
			double strPerDC = 5 * adv;
			
			Characteristic str = HeroDesigner.getActiveHero()
					.getCharacteristic(Constants.STR);
			if (str != null) {
				double primary = str.getPrimaryValue() - minStrength;
				if (primary < 0) {
					primary = 0;
				}
				double secondary = str.getSecondaryValue() - minStrength;
				if (secondary < 0) {
					secondary = 0;
				}
				if (primary / strPerDC < dc - minus || HeroDesigner.getActiveTemplate().is6E()) {
					strDC += Rounder.roundDown(primary / strPerDC);
				} else {
					strDC = (dc - minus) * 2;
				}
				if (primary / strPerDC < stdSTR || HeroDesigner.getActiveTemplate().is6E()) {
					stdSTR += primary / strPerDC;
				} else {
					stdSTR = stdSTR * 2;
				}
				if (secondary / strPerDC < dc - minus || HeroDesigner.getActiveTemplate().is6E()) {
					strDC2 += secondary / strPerDC;
				} else {
					strDC2 = (dc - minus) * 2;
				}
				if (secondary / strPerDC < stdSTR2 || HeroDesigner.getActiveTemplate().is6E()) {
					stdSTR2 += secondary / strPerDC;
				} else {
					stdSTR2 = stdSTR2 * 2;
				}
			}
		}
		int dice = dc / 3;
		int rem = dc % 3;
		if (dice != 0) {
			ret += dice;
		}
		if (rem == 1) {
			if (dice > 0) {
				ret += "d6+1";
			} else {
				ret += "1 point";
			}
		} else if (rem == 2) {
			ret += " 1/2d6";
		} else {
			ret += "d6";
		}

		ret = ret.trim();

		if (minus != 0) {
			ret += "-" + minus;
		}
		if ((strDC != dc - minus)
				|| ((strDC != strDC2) && (strDC2 != dc - minus))) {
			ret += " (";
			dice = strDC / 3;
			rem = strDC % 3;
			if (rem == 1) {
				ret += (dice != 0 ? "" + dice : "") + "d6+1";
			} else if (rem == 2) {
				if (minus == 0) {
					ret += (dice != 0 ? dice + " " : "") + "1/2d6";
				} else {
					ret += (dice != 0 ? "" + (dice + 1) : "") + "d6 - 1";
				}
			} else {
				ret += (dice != 0 ? "" + dice : "") + "d6";
			}
			if (strDC != strDC2) {
				ret += " / ";
				dice = strDC2 / 3;
				rem = strDC2 % 3;
				if (rem == 1) {
					ret += (dice != 0 ? "" + dice : "") + "d6+1";
				} else if (rem == 2) {
					if (minus == 0) {
						ret += (dice != 0 ? dice + " " : "") + "1/2d6";
					} else {
						ret += (dice != 0 ? "" + (dice + 1) : "") + "d6-1";
					}
				} else {
					ret += (dice != 0 ? "" + dice : "") + "d6";
				}
			}
			ret += " w/STR)";
		}

		if (useStandardEffect()) {
			if (doesBODY()) {
				ret += " (standard effect: " + stdSTR;
				if (stdSTR != stdSTR2) {
					ret += " / " + stdSTR2;
				}
				ret += " BODY, " + stdSTR * stunMult;
				if (stdSTR != stdSTR2) {
					ret += " / " + stdSTR2 * stunMult;
				}
				ret += " STUN)";
			} else {
				ret += " (standard effect: " + stdSTR * stunMult;
				if (stdSTR != stdSTR2) {
					ret += " / " + stdSTR2 * stunMult;
				}
				ret += " STUN)";
			}
		}
		return ret;
	}
}